# Figure 1 : Computation time



include("src/socg.jl")


# PARAMETERS

    ## General parameters

n1 = 5  #50 # sample size of the sample from X
n2 = 5  #50 # sample size of the sample from Y

MC = 1000 # Number of replications

    ## Parameters for the pseudo metrics

r_params = [2,5] # pairwise matrices of size rxr
B_boot = 1000 # number of bootstrap to estimate the distribution D_{Xn,r} from a sample
vect_t = [[0.1, 0.2, 0.5, 1.0, 5.0, 10.0, 100.0], [0.5]]
h_params = [0.05, 0.5, 1] # parameters for the DTM-signature


    ## Alternatives for data generation

p1 = 1.5
p2 = 1.5

    ## Pseudo-distances

function d_tilde_boot_1(x,y)
    return dr_1_boot(x,y,B_boot)
end

function d_tilde_boot_2(x,y)
    return dr_2_boot(x,y,B_boot)
end

function d_boot_1(x,y)
    return d_boot(x,y,B_boot,r_params[1],vect_t[1])
end

function d_boot_2(x,y)
    return d_boot(x,y,B_boot,r_params[2],vect_t[2])
end

function d_dtm_1(x,y)
    return d_dtm(x,y,h_params[1])
end

function d_dtm_2(x,y)
    return d_dtm(x,y,h_params[2])
end

function d_dtm_3(x,y)
    return d_dtm(x,y,h_params[3])
end

pseudo_distances = [dr_1,dr_2,d_boot_1,d_boot_2,d_tilde_boot_1,d_tilde_boot_2,d_shape,d_dtm_1,d_dtm_2,d_dtm_3] # 


samp1 = generate_lp_ball(n1,p1)
samp2 = generate_lp_ball(n1,p2)
ntot = n1 + n2
sample_pooled = hcat(samp1, samp2)
dist_pooled = Distances.pairwise(Distances.SqEuclidean(1e-12), sample_pooled, dims = 2)

stat_H0 = Vector{Any}(undef,MC)

time_ = Float64[]
for pd in pseudo_distances

    # We use the function a first time, before counting elapsed time.
    perm = shuffle(1:ntot)
    dist1 = view(dist_pooled,perm[1 : n1],perm[1 : n1])
    dist2 = view(dist_pooled,perm[(n1 + 1) : ntot],perm[(n1 + 1) : ntot])
    pd(dist1,dist2)

    push!(time_ , @elapsed begin

    for mc in 1:MC
        perm = shuffle(1:ntot)
        dist1 = view(dist_pooled,perm[1 : n1],perm[1 : n1])
        dist2 = view(dist_pooled,perm[(n1 + 1) : ntot],perm[(n1 + 1) : ntot])
        stat_H0[mc] = pd(dist1,dist2)
    end

    end
    )

end

print(time_./MC)
