# Figure 2 : Power two-sample test



include("src/socg.jl")


# PARAMETERS

    ## General parameters

#n1 = 10 #50 # sample size of the sample from X
#n2 = 10 #50 # sample size of the sample from Y

MC = 1000 #1000 # Number of replications
params_alpha = [0.05] #[0.05, 0.1]
B_perm = 100 # Number of permutations to compute the p-value

    ## Parameters for the pseudo metrics

r_params = [2,5] # pairwise matrices of size rxr
B_boot = 1000 # number of bootstrap to estimate the distribution D_{Xn,r} from a sample
vect_t = [[0.1, 0.2, 0.5, 1.0, 5.0, 10.0, 100.0], [0.5]]
h_params = [0.05, 0.5, 1] # parameters for the DTM-signature


    ## Alternatives for data generation

p1 = 1.5
p2_params = [1.55, 1.6] #[1.4, 1.45, 1.5, 

kappa1 = 2.0
kappa2_params = [1.0, 1.5, 2.0, 2.5, 3.0]


    ## Pseudo-distances

function d_tilde_boot_1(x,y)
    return dr_1_boot(x,y,B_boot)
end

function d_tilde_boot_2(x,y)
    return dr_2_boot(x,y,B_boot)
end

function d_boot_1(x,y)
    return d_boot(x,y,B_boot,r_params[1],vect_t[1])
end

function d_boot_2(x,y)
    return d_boot(x,y,B_boot,r_params[2],vect_t[2])
end

function d_dtm_1(x,y)
    return d_dtm(x,y,h_params[1])
end

function d_dtm_2(x,y)
    return d_dtm(x,y,h_params[2])
end

function d_dtm_3(x,y)
    return d_dtm(x,y,h_params[3])
end

pseudo_distances = [d_boot_1,d_boot_2,d_shape,d_dtm_1,d_dtm_2,d_dtm_3] #[dr_1,dr_2,d_tilde_boot_1,d_tilde_boot_2,d_boot_1,d_boot_2,d_shape,d_dtm_1,d_dtm_2,d_dtm_3]


for kappa2 in kappa2_params #p2 in p2_params

    print("\n"," kappa2 = ", kappa2,"\n")

    for n in [100]

        n1 = n
        n2 = n

        print("\n"," n = ", n,"\n")

        pvals = zeros(MC,length(pseudo_distances))
        for m in 1:MC
            if (mod(m,10) == 0)
                print(Int(floor(m/10)))
            end

            Sample_1 =  generate_vonMises_circle(n1,kappa1,[0,1]) # generate_lp_ball(n1,p1)
            Sample_2 =  generate_vonMises_circle(n2,kappa2,[0,1]) # generate_lp_ball(n1,p2)

            pvals[m,:] = two_sample_test_bis(pseudo_distances,Sample_1,Sample_2,B_perm) #two_sample_test(pseudo_distances,Sample_1,Sample_2,B_perm)
        end

        print("\n")
        for alpha in params_alpha
            print(mean(pvals.<=alpha,dims = 1))
            print("\n")
        end

    end

end
