# Figure 3 : Power test of uniformity



include("src/socg.jl")


# PARAMETERS

    ## General parameters

#n1 = 10 #50 # sample size of the sample from X
#n2 = 10 #50 # sample size of the sample from Y

MC = 1000 # Number of replications
params_alpha = [0.05, 0.1]
B = 1000 # Number of replications to compute the critical value

    ## Parameters for the pseudo metrics

r_params = [2,5] # pairwise matrices of size rxr
B_boot = 1000 # number of bootstrap to estimate the distribution D_{Xn,r} from a sample
vect_t = [[0.1, 0.2, 0.5, 1.0, 5.0, 10.0, 100.0], [0.5]]

vect_prop_near_neigh = [0.1,0.2,0.5,1]

    ## Alternatives for data generation

p1 = 2
p2_params =  [1.8, 1.85, 1.9, 1.95, 2]

kappa1 = 0
kappa2_params = [0, 0.1, 0.2, 0.5,1, 2, 5]

kappa2_mixture_params = [0, 10, 20, 50, 100, 200, 300]


radius = 1
center = [0,1]


R"""
library(sphunif);
library(foreach);
library(doParallel);
nCores <- 8;
registerDoParallel(nCores);
""";


for kappa2 in kappa2_params #p2 in p2_params #kappa2 in kappa2_mixture_params

    print("\n"," kappa2 = ", kappa2,"\n")

    for n in [100]

        t_select_param = Test_Homogeneity_Param_Selection(n,vect_prop_near_neigh,B,CircleData);

        print("\n"," n = ", n,"\n")

        M = r_params[1]
        vectt = vect_t[1]
        test_1 = Test_Homogeneity_circle(n,B,M,vectt,MC,radius,center,Inf)

        M = r_params[2]
        vectt = vect_t[2]
        test_2 = Test_Homogeneity_circle(n,B,M,vectt,MC,radius,center,Inf)

        pval_test1 = zeros(MC)
        pval_test2 = zeros(MC)
        pval_Rayleigh = zeros(MC)
        pval_Bingham = zeros(MC)
        pval_dtm = zeros(MC)
        
        for m in 1:MC

            Sample = generate_vonMises_circle(n,kappa2,[0,1]) # generate_lp_ball(n,p2)  #generate_mixture_vonMises_circle(n,kappa2)

            pval_test1[m] = apply_test(test_1,Sample)[2]
            pval_test2[m] = apply_test(test_2,Sample)[2]

            pval_Rayleigh[m] = Rayleigh_test(Sample)
            pval_Bingham[m] = Bingham_test(Sample)

            data  = [atan(Sample[2,i],Sample[1,i]).+pi for i in 1:100 ]
            pval_dtm[m] = apply_test(t_select_param,CircleData(100,data),"iidness")[1]
        end

        print("\n",mean(pval_test1.<=0.05)," ",mean(pval_test2.<=0.05)," ",mean(pval_Rayleigh.<=0.05)," ",mean(pval_Bingham.<=0.05)," ",mean(pval_dtm.<=0.05))

    end

end
