
# dr

function dr_1(
    dist1,
    dist2
)
# r = 2
    N1 = length(dist1)
    N2 = length(dist2)

    term_1 = mean(exp.((-0.5).*(vcat([[dist1[i] - dist1[j] for j in 1:N1] for i in 1:N1]...).^2)))
    term_2 = mean(exp.((-0.5).*(vcat([[dist2[i] - dist2[j] for j in 1:N2] for i in 1:N2]...).^2)))
    term_3 = mean(exp.((-0.5).*(vcat([[dist1[i] - dist2[j] for j in 1:N2] for i in 1:N1]...).^2)))

    return term_1 + term_2 - 2*term_3
end

function dr_1_boot(
    dist1,
    dist2,
    B
)
# r = 2
    N1 = length(dist1)
    N2 = length(dist2)

    ind0 = [[rand(1:N1), rand(1:N1), rand(1:N2), rand(1:N2)] for _ in 1:B]

    ind = [[i_[1],i_[2]] for i_ in ind0]
    term_1 = mean(exp.((-0.5).*([dist1[i[1]] - dist1[i[2]] for i in ind].^2)))
    
    ind = [[i_[3],i_[4]] for i_ in ind0]
    term_2 = mean(exp.((-0.5).*([dist2[i[1]] - dist2[i[2]] for i in ind].^2)))

    ind = [[i_[1],i_[3]] for i_ in ind0]
    term_3 = mean(exp.((-0.5).*([dist1[i[1]] - dist2[i[2]] for i in ind].^2)))

    ind = [[i_[2],i_[4]] for i_ in ind0]
    term_4 = mean(exp.((-0.5).*([dist1[i[1]] - dist2[i[2]] for i in ind].^2)))

    ind = [[i_[1],i_[4]] for i_ in ind0]
    term_5 = mean(exp.((-0.5).*([dist1[i[1]] - dist2[i[2]] for i in ind].^2)))

    ind = [[i_[2],i_[3]] for i_ in ind0]
    term_6 = mean(exp.((-0.5).*([dist1[i[1]] - dist2[i[2]] for i in ind].^2)))

    return term_1 + term_2 - 0.5*(term_3 + term_4 + term_5 + term_6) #2*term_3
end

function dr_2(
    dist1,
    dist2
)
# r = 3
    n1 = size(dist1)[1]
    n2 = size(dist2)[1]

    dist1_mat3 = [[dist1[i,j], dist1[i,k], dist1[j,k]] for k in 1:n1, j in 1:n1, i in 1:n1]
    dist2_mat3 = [[dist2[i,j], dist2[i,k], dist2[j,k]] for k in 1:n2, j in 1:n2, i in 1:n2]

    N1 = length(dist1_mat3)
    N2 = length(dist2_mat3)

    term_1 = mean(exp.((-0.5).*(vcat([[sum((dist1_mat3[i] .- dist1_mat3[j]).^2) for j in 1:N1] for i in 1:N1]...))))
    term_2 = mean(exp.((-0.5).*(vcat([[sum((dist2_mat3[i] .- dist2_mat3[j]).^2) for j in 1:N2] for i in 1:N2]...))))
    term_3 = mean(exp.((-0.5).*(vcat([[sum((dist1_mat3[i] .- dist2_mat3[j]).^2) for j in 1:N2] for i in 1:N1]...))))

    return term_1 + term_2 - 2*term_3

end

function mat_dist3(
    indices,
    dist
)
    return [dist[indices[1],indices[2]], dist[indices[1],indices[3]], dist[indices[2],indices[3]]]
end

function dr_2_boot(
    dist1,
    dist2,
    B
)
# r = 3
    n1 = size(dist1)[1]
    n2 = size(dist2)[1]

    ind0 = [[rand(1:n1), rand(1:n1), rand(1:n1), rand(1:n1), rand(1:n1), rand(1:n1), rand(1:n2), rand(1:n2), rand(1:n2), rand(1:n2), rand(1:n2), rand(1:n2)] for _ in 1:B]

    ind = [i_[1:6] for i_ in ind0]
    term_1 = mean(exp.((-0.5).*([sum((mat_dist3(ind[i][1:3],dist1) .- mat_dist3(ind[i][4:6],dist1)).^2) for i in 1:B])))

    ind = [i_[7:12] for i_ in ind0]
    term_2 = mean(exp.((-0.5).*([sum((mat_dist3(ind[i][1:3],dist2)  .- mat_dist3(ind[i][4:6],dist2) ).^2) for i in 1:B] )))

    ind = [i_[vcat(1:3, 7:9)] for i_ in ind0]
    term_3 = mean(exp.((-0.5).*([sum((mat_dist3(ind[i][1:3],dist1) .- mat_dist3(ind[i][4:6],dist2)).^2) for i in 1:B] )))

    return term_1 + term_2 - 2*term_3

end

# d_boot

function d_boot(
    dist1,
    dist2,
    B,
    M,
    vect_t
)
    phi1 = characteristic_function_boot(dist1,B,M,vect_t)
    phi2 = characteristic_function_boot(dist2,B,M,vect_t)

    return mean([mean(abs.(x)) for x in (phi1 .- phi2)]) # abs2.() to get sq norm ??
end

function characteristic_function_boot(
    dist_matrix,
    B = 1000, # Number of bootstrap samples
    M = 5, # 5 max ; Maximum sample size for distance matrices distributions, m in {2,...,M} are used.
    vect_t = [1] # 4 elements max ; All numbers used to compute the characteristic function at t. We compute char. funct. at T_m = (t_1,\ldots,t_{m^2}) for every t_1,...t_{m^2} in vect_t.
)
# We return a list of M-1 vectors.
# The m-1 vector provides the values of the characteristic function of the bootstrap samples, for the different values of T_m.
# We start by computing the sum, and at the end, we divide by B.

    size_T = length(vect_t)
    n = size(dist_matrix)[1]

    phi_M = [zeros(Int(size_T^(m*(m-1)/2)))*im for m in 2:M]
    list_pair_indices = vcat([[[i,j] for i in 1:M if i<j] for j in 1:M]...)

    T = [(multiset_permutations(repeat(vect_t,Int(m*(m-1)/2)),Int(m*(m-1)/2)) |> collect) for m in 2:M]
    # Enumerate all elements on which we will compute characteristic functions.

    for b in 1:B
        indices = sample(1:n,M)
        distances = [dist_matrix[indices[pair[1]], indices[pair[2]]] for pair in list_pair_indices]
        # Vector of distances between chosen points (1,2), (1,3), (2,3), (1,4), (2,4), (3,4),... (M-1,M).
        # We keep the m(m-1)/2 first elements for every m.
        for m in 2:M
            X = distances[1:Int(m*(m-1)/2)]
            phi_M[m-1] .+= [exp(im*sum(X.*t)) for t in T[m-1]]
        end
    end

    for m in 2:M
        phi_M[m-1] = phi_M[m-1] ./ B
    end

    return phi_M

end


# d_dtm

function d_dtm(
    dist1,
    dist2,
    h
)
    n1 = size(dist1)[1]
    k1 = Int(ceil(n1*h))
    n2 = size(dist2)[1]
    k2 = Int(ceil(n2*h))

    @assert(n1==n2,"the two distance matrices should have the same size")

    dtm_1 = sort([ mean(sort([ dist1[i,j] for j in 1:n1 ])[1:k1]) for i in 1:n1])
    dtm_2 = sort([ mean(sort([ dist2[i,j] for j in 1:n2 ])[1:k2]) for i in 1:n2])

    return  mean(abs.(sqrt.(dtm_1) .- sqrt.(dtm_2))) 
end


# d_shape

function d_shape(
    dist1,
    dist2
)
    n1 = size(dist1)[1]
    n2 = size(dist2)[1]

    @assert(n1==n2,"the two distance matrices should have the same size")

    sq_distances_1 = sort(vcat([[ dist1[i,j] for j in (i+1):n1 ] for i in 1:n1]...))
    sq_distances_2 = sort(vcat([[ dist2[i,j] for j in (i+1):n2 ] for i in 1:n2]...))

    return  mean(abs.(sqrt.(sq_distances_1) .- sqrt.(sq_distances_2))) 
end
