# Some sampling functions

function generate_regular_grid_circle(
    sample_size :: Integer,
    radius = 1.0,
    center = [0,0],
    initial_angle = 0
)
    step = 2*pi/sample_size
    angles = [i*step + initial_angle for i in 1:sample_size]
    return(collect(transpose(hcat(center[1] .+ (radius.*cos.(angles)), center[2] .+ (radius.*sin.(angles)) ))))
end

function generate_vonMises_circle(
    sample_size :: Integer,
    κ = 0,
    center = [0,1]
)

    @rput(sample_size)
    kappa = κ
    @rput(kappa)
    @rput(center)

    R"""
    sample = r_alt(n = sample_size, p = 2, alt = "vMF",kappa = kappa, mu = center)[, , 1]
    """
    points = collect(transpose(@rget(sample)))
    return points
end

function generate_uniform_circle(
    sample_size :: Integer,
    radius = 1.0,
    center = [0,0]
)
    angles = 2*pi*(rand(sample_size))
    return(collect(transpose(hcat(center[1] .+ (radius.*cos.(angles)), center[2] .+ (radius.*sin.(angles)) ))))
end

function generate_lp_ball(
    sample_size::Integer,
    p = 2,
)
    pre_sample = generate_uniform_circle(sample_size)
    sample = pre_sample ./ ((sum(abs.(pre_sample) .^p,dims = 1)).^(1/p))

    return sample
end

function generate_mixture_vonMises_circle(
    sample_size :: Integer,
    κ = 0,
    center = [0,1]
)

    @rput(sample_size)
    kappa = κ
    @rput(kappa)
    @rput(center)

    R"""
    sample = r_alt(n = sample_size, p = 2, alt = "MvMF",kappa = kappa, mu = center)[, , 1]
    """
    points = collect(transpose(@rget(sample)))
    return points
end

function generate_uniform_segment(
    sample_size :: Integer,
    init_point = [0,0],
    end_point = [1,0],
)
    step = rand(sample_size)
    return(collect(transpose(hcat( (end_point[1] - init_point[1]) .* step .+ init_point[1] , (end_point[2] - init_point[2]) .* step .+ init_point[2] ))))
end


function generate_several_shapes(
    sample_sizes,
    params_pballs # contains a list with values for p, radius, and center, for the p-balls
)

    n_shapes = length(params_pballs)

    sample_ = []

    for (idx, params) in enumerate(params_pballs)
        if idx == 1
            sample_ = (params[2] .* generate_lp_ball(sample_sizes[idx],params[1])) .+ params[3] 
        else
            x = (params[2] .* generate_lp_ball(sample_sizes[idx],params[1])) .+ params[3] 
            sample_ = hcat(sample_, x)
        end
    end

    return sample_ #reshape(sample,2,sample_size*n_shapes)
end