
function projection_matrix(
    circle_points
)
return([vec(circle_points[:,i]*collect(transpose(circle_points[:,i]))) for i in 1:size(circle_points)[2]])
end



function tomato_clustering(
spl,
k = 30,
k_DTM = 50
)
normal = get_mass_normal_vector(spl)[2]
proj = 1 .*(hcat(projection_matrix(normal)...))
mixted = vcat(spl,proj)

samp = collect(transpose(mixted))

py"""
import gudhi
from gudhi.clustering.tomato import Tomato

t = Tomato(graph_type='knn',density_type='logDTM', k = $k, k_DTM = $k_DTM) 
t.fit($samp)
t.plot_diagram()

t.n_clusters_=11
plt.scatter($samp[:,0],$samp[:,1],marker='.',s=1,c=t.labels_)
plt.show()
"""

return py"t.labels_"
end