function two_sample_test(
    pseudo_distance_params,
    samp1,
    samp2,
    MC = 1000
)

sample_pooled = hcat(samp1, samp2)
dist_pooled = Distances.pairwise(Distances.SqEuclidean(1e-12), sample_pooled, dims = 2)

n1 = size(samp1)[2]
n2 = size(samp2)[2]
ntot = n1 + n2

stat_H0 = Vector{Any}(undef,MC)
for mc in 1:MC
    perm = shuffle(1:ntot)
    dist1 = view(dist_pooled,perm[1 : n1],perm[1 : n1])
    dist2 = view(dist_pooled,perm[(n1 + 1) : ntot],perm[(n1 + 1) : ntot])
    stat_H0[mc] = [pseudo_distance(dist1,dist2) for pseudo_distance in pseudo_distance_params]
end

dist1 = view(dist_pooled,1 : n1,1 : n1)
dist2 = view(dist_pooled,(n1 + 1) : ntot,(n1 + 1) : ntot)
stat = [pseudo_distance(dist1,dist2) for pseudo_distance in pseudo_distance_params]

return mean(hcat(stat_H0...) .>=  stat, dims = 2)

end

function two_sample_test_bis(
    pseudo_distance_params,
    samp1,
    samp2,
    MC = 1000
)

MC = Int(ceil(MC/2))

sample_pooled = hcat(samp1, samp2)
dist_pooled = Distances.pairwise(Distances.SqEuclidean(1e-12), sample_pooled, dims = 2)

n1 = size(samp1)[2]
n2 = size(samp2)[2]
ntot = n1 + n2
n = min(n1, n2)
n = Int(floor(n/2))

# Estimation of the test stat distribution under H0
distribution_estimation_s1 = Vector{Any}(undef,MC)
for mc in 1:MC
    perm = shuffle(1:n1)
    dist1 = view(dist_pooled,perm[1 : n],perm[1 : n])
    dist2 = view(dist_pooled,perm[(n + 1) : (2*n)],perm[(n + 1) : (2*n)])
    distribution_estimation_s1[mc] = [pseudo_distance(dist1,dist2)  for pseudo_distance in pseudo_distance_params]
end

distribution_estimation_s2 = Vector{Any}(undef,MC)
for mc in 1:MC
    perm = shuffle(1:n2)
    dist1 = view(dist_pooled,n1 .+ perm[1 : n],n1 .+ perm[1 : n])
    dist2 = view(dist_pooled,n1 .+ perm[(n + 1) : (2*n)],n1 .+ perm[(n + 1) : (2*n)])
    distribution_estimation_s2[mc] = [pseudo_distance(dist1,dist2)  for pseudo_distance in pseudo_distance_params]
end

dist1 = view(dist_pooled,1 : n,1 : n)
dist2 = view(dist_pooled,(n1 + 1) : (n1 + n),(n1 + 1) : (n1 + n))
stat = [pseudo_distance(dist1,dist2) for pseudo_distance in pseudo_distance_params]

return mean(hcat(vcat(distribution_estimation_s1,distribution_estimation_s2)...) .>=  stat, dims = 2)
end